<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sample - <?php echo e($sample->sample_code); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #1c1f26;
            margin: 0;
            padding: 20px;
            color: #fff;
        }
        .card {
            width: 300px;
            margin: auto;
            border-radius: 12px;
            overflow: hidden;
            background: linear-gradient(160deg, #2a2f3a, #1b1e24);
            box-shadow: 0 6px 18px rgba(0,0,0,0.5);
            padding: 20px;
            position: relative;
        }
        .card-header {
            text-align: center;
            margin-bottom: 15px;
        }
        .card-header h2 {
            margin: 0;
            font-size: 20px;
            color: #00e5ff;
        }
        .field {
            margin-bottom: 12px;
        }
        .label {
            font-size: 12px;
            color: #aaa;
        }
        .value {
            font-size: 14px;
            font-weight: bold;
            color: #fff;
        }
        .highlight {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 6px;
            background: linear-gradient(90deg, #ff005e, #ffbb00, #00ffcc);
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="highlight"></div>
        <div class="card-header">
            <h2><?php echo e($sample->product_name); ?></h2>
        </div>
        <div class="field">
            <div class="label">Sample Code</div>
            <div class="value"><?php echo e($sample->sample_code); ?></div>
        </div>
        <div class="field">
            <div class="label">Date</div>
            <div class="value"><?php echo e($sample->date); ?></div>
        </div>
        <div class="field">
            <div class="label">Purity</div>
            <div class="value"><?php echo e($sample->purity); ?></div>
        </div>
        <div class="field">
            <div class="label">Molecular Weight</div>
            <div class="value"><?php echo e($sample->molecular_weight); ?></div>
        </div>
        <div class="field">
            <div class="label">Company</div>
            <div class="value"><?php echo e($sample->company_name); ?></div>
        </div>
        <div class="field">
            <div class="label">Purpose</div>
            <div class="value"><?php echo e($sample->purpose); ?></div>
        </div>
        <div class="field">
            <div class="label">Remarks</div>
            <div class="value"><?php echo e($sample->remarks); ?></div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\sampletracker_full_installer\sample\resources\views\samples\public_view.blade.php ENDPATH**/ ?>