<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <?php if(session('ok')): ?>
        <div class="alert alert-success">
            <?php echo e(session('ok')); ?>

        </div>
    <?php endif; ?>

    <div class="card shadow">
        <div class="card-header bg-primary text-white text-center">
            <h4 class="mb-0">➕ Add New Sample</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('samples.store')); ?>">
                <?php echo csrf_field(); ?>

                <!-- Date -->
                <div class="form-group">
                    <label for="date">Date</label>
                    <input type="date" name="date" id="date"
                           class="form-control"
                           value="<?php echo e(old('date')); ?>">
                </div>

                <!-- Product Name -->
                <div class="form-group">
                    <label for="product_name">Product Name (Commercial / Technical)</label>
                    <input type="text" name="product_name" id="product_name" class="form-control" required
                           value="<?php echo e(old('product_name')); ?>">
                </div>

                <!-- Purity & Molecular Weight -->
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="purity">Purity</label>
                        <input type="text" name="purity" id="purity"
                               class="form-control"
                               value="<?php echo e(old('purity')); ?>">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="molecular_weight">Molecular Weight</label>
                        <input type="text" name="molecular_weight" id="molecular_weight"
                               class="form-control"
                               value="<?php echo e(old('molecular_weight')); ?>">
                    </div>
                </div>

                <!-- Company Name -->
                <div class="form-group">
                    <label for="company_name">Company Name</label>
                    <input type="text" name="company_name" id="company_name"
                           class="form-control"
                           value="<?php echo e(old('company_name')); ?>">
                </div>

                <!-- Purpose -->
                <div class="form-group">
                    <label for="purpose">Purpose</label>
                    <textarea name="purpose" id="purpose" class="form-control" rows="2"><?php echo e(old('purpose')); ?></textarea>
                </div>

                <!-- Remarks -->
                <div class="form-group">
                    <label for="remarks">Remarks</label>
                    <textarea name="remarks" id="remarks" class="form-control" rows="2"><?php echo e(old('remarks')); ?></textarea>
                </div>

                <!-- Submit -->
                <div class="text-center">
                    <button type="submit" class="btn btn-success px-4">
                        💾 Save & Generate Label
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\sampletracker_full_installer\sample\resources\views\samples\create.blade.php ENDPATH**/ ?>