@extends('layouts.app')

@section('content')
<div class="container">
    <h1 class="mb-4">Samples</h1>
    <a href="{{ route('samples.create') }}" class="btn btn-primary mb-3">New Sample</a>

    <table class="table">
        <thead><tr><th>ID</th><th>Product</th><th>Company</th><th>Delete</th><th>Edit</th></tr></thead>
        <tbody>
        @foreach($samples as $s)
            <tr>
                <td>{{ $s->id }}</td>
                <td>{{ $s->product_name }}</td>
                <td>{{ $s->company_name }}</td>
              
                <td>
                   <center> <a href="{{ route('samples.label', $s->id) }}" target="_blank">Label</a>
                </center>
                </td>

                  <td>
                   <center>
                    <form method="POST" action="{{ route('samples.destroy', $s->id) }}" style="display:inline">
                        @csrf @method('DELETE')
                        <button class="btn btn-primary" onclick="return confirm('Delete?')">Delete</button>
                    </form></center>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

    {{ $samples->links() }}
</div>
@endsection
