@extends('layouts.app')

@section('content')
<div class="container mt-4">
    @if(session('ok'))
        <div class="alert alert-success">
            {{ session('ok') }}
        </div>
    @endif

    <div class="card shadow">
        <div class="card-header bg-primary text-white text-center">
            <h4 class="mb-0">➕ Add New Sample</h4>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('samples.store') }}">
                @csrf

                <!-- Date -->
                <div class="form-group">
                    <label for="date">Date</label>
                    <input type="date" name="date" id="date"
                           class="form-control"
                           value="{{ old('date') }}">
                </div>

                <!-- Product Name -->
                <div class="form-group">
                    <label for="product_name">Product Name (Commercial / Technical)</label>
                    <input type="text" name="product_name" id="product_name" class="form-control" required
                           value="{{ old('product_name') }}">
                </div>

                <!-- Purity & Molecular Weight -->
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="purity">Purity</label>
                        <input type="text" name="purity" id="purity"
                               class="form-control"
                               value="{{ old('purity') }}">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="molecular_weight">Molecular Weight</label>
                        <input type="text" name="molecular_weight" id="molecular_weight"
                               class="form-control"
                               value="{{ old('molecular_weight') }}">
                    </div>
                </div>

                <!-- Company Name -->
                <div class="form-group">
                    <label for="company_name">Company Name</label>
                    <input type="text" name="company_name" id="company_name"
                           class="form-control"
                           value="{{ old('company_name') }}">
                </div>

                <!-- Purpose -->
                <div class="form-group">
                    <label for="purpose">Purpose</label>
                    <textarea name="purpose" id="purpose" class="form-control" rows="2">{{ old('purpose') }}</textarea>
                </div>

                <!-- Remarks -->
                <div class="form-group">
                    <label for="remarks">Remarks</label>
                    <textarea name="remarks" id="remarks" class="form-control" rows="2">{{ old('remarks') }}</textarea>
                </div>

                <!-- Submit -->
                <div class="text-center">
                    <button type="submit" class="btn btn-success px-4">
                        💾 Save & Generate Label
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
