<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    protected $fillable = ['user_id','ip','action','description','model','model_id'];

    public static function log($userId, $ip, $action, $description = null, $model = null, $modelId = null)
    {
        return static::create([
            'user_id' => $userId,
            'ip' => $ip,
            'action' => $action,
            'description' => $description,
            'model' => is_string($model) ? $model : (is_object($model) ? get_class($model) : null),
            'model_id' => $modelId
        ]);
    }
}
